// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     net/interfaces/proxy_resolver_service.mojom
//

package org.chromium.mojom.net.interfaces;

public final class ProxyServer extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 24;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public int scheme;
    public String host;
    public short port;

    private ProxyServer(int version) {
        super(STRUCT_SIZE, version);
    }

    public ProxyServer() {
        this(0);
    }

    public static ProxyServer deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static ProxyServer decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        ProxyServer result = new ProxyServer(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.scheme = decoder0.readInt(8);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.port = decoder0.readShort(12);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.host = decoder0.readString(16, true);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(scheme, 8);
        encoder0.encode(port, 12);
        encoder0.encode(host, 16, true);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        ProxyServer other = (ProxyServer) object;
        if (this.scheme != other.scheme)
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.host, other.host))
            return false;
        if (this.port != other.port)
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(scheme);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(host);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(port);
        return result;
    }
}

